Attribute VB_Name = "Module1"
Private Const MMSYSERR_NOERROR = 0
Private Const MAXPNAMELEN = 32
Private Const MIXER_LONG_NAME_CHARS = 64
Private Const MIXER_SHORT_NAME_CHARS = 16
Private Const MIXER_GETLINEINFOF_COMPONENTTYPE = &H3&
Private Const MIXER_GETLINEINFOF_SOURCE = &H1&
Private Const MIXER_GETCONTROLDETAILSF_VALUE = &H0&
Private Const MIXER_GETLINECONTROLSF_ONEBYTYPE = &H2&
Private Const MIXERLINE_COMPONENTTYPE_DST_FIRST = &H0&
Private Const MIXERLINE_COMPONENTTYPE_SRC_FIRST = &H1000&
Private Const MIXERLINE_COMPONENTTYPE_DST_SPEAKERS = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 4)
Private Const MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 3)
Private Const MIXERLINE_COMPONENTTYPE_SRC_LINE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 2)
Private Const MIXERCONTROL_CT_CLASS_FADER = &H50000000
Private Const MIXERCONTROL_CT_UNITS_UNSIGNED = &H30000
Private Const MIXERCONTROL_CONTROLTYPE_FADER = (MIXERCONTROL_CT_CLASS_FADER Or MIXERCONTROL_CT_UNITS_UNSIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_VOLUME = (MIXERCONTROL_CONTROLTYPE_FADER + 1)
Private Const MIXERLINE_COMPONENTTYPE_DST_WAVEIN = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 7)
Private Const MIXER_SETCONTROLDETAILSF_VALUE = &H0&

Private Type MIXERCAPS
    wMid As Integer                   '  manufacturer id
    wPid As Integer                   '  product id
    vDriverVersion As Long            '  version of the driver
    szPname As String * MAXPNAMELEN   '  product name
    fdwSupport As Long                '  misc. support bits
    cDestinations As Long             '  count of destinations
End Type

Private Type MIXERCONTROL
    cbStruct As Long           '  size in Byte of MIXERCONTROL
    dwControlID As Long        '  unique control id for mixer device
    dwControlType As Long      '  MIXERCONTROL_CONTROLTYPE_xxx
    fdwControl As Long         '  MIXERCONTROL_CONTROLF_xxx
    cMultipleItems As Long     '  if MIXERCONTROL_CONTROLF_MULTIPLE set
    szShortName As String * MIXER_SHORT_NAME_CHARS  ' short name of control
    szName As String * MIXER_LONG_NAME_CHARS        ' long name of control
    lMinimum As Long           '  Minimum value
    lMaximum As Long           '  Maximum value
    reserved(10) As Long       '  reserved structure space
End Type

Private Type MIXERCONTROLDETAILS
    cbStruct As Long       '  size in Byte of MIXERCONTROLDETAILS
    dwControlID As Long    '  control id to get/set details on
    cChannels As Long      '  number of channels in paDetails array
    item As Long           '  hwndOwner or cMultipleItems
    cbDetails As Long      '  size of _one_ details_XX struct
    paDetails As Long      '  pointer to array of details_XX structs
End Type

Private Type MIXERCONTROLDETAILS_UNSIGNED
    dwValue As Long        '  value of the control
End Type

Private Type MIXERLINE
    cbStruct As Long               '  size of MIXERLINE structure
    dwDestination As Long          '  zero based destination index
    dwSource As Long               '  zero based source index (if source)
    dwLineID As Long               '  unique line id for mixer device
    fdwLine As Long                '  state/information about line
    dwUser As Long                 '  driver specific information
    dwComponentType As Long        '  component type line connects to
    cChannels As Long              '  number of channels line supports
    cConnections As Long           '  number of connections (possible)
    cControls As Long              '  number of controls at this line
    szShortName As String * MIXER_SHORT_NAME_CHARS
    szName As String * MIXER_LONG_NAME_CHARS
    dwType As Long
    dwDeviceID As Long
    wMid  As Integer
    wPid As Integer
    vDriverVersion As Long
    szPname As String * MAXPNAMELEN
End Type

Private Type MIXERLINECONTROLS
    cbStruct As Long       '  size in Byte of MIXERLINECONTROLS
    dwLineID As Long       '  line id (from MIXERLINE.dwLineID)
                           '  MIXER_GETLINECONTROLSF_ONEBYID or
    dwControl As Long      '  MIXER_GETLINECONTROLSF_ONEBYTYPE
    cControls As Long      '  count of controls pmxctrl points to
    cbmxctrl As Long       '  size in Byte of _one_ MIXERCONTROL
    pamxctrl As Long       '  pointer to first MIXERCONTROL array
End Type

Private Declare Function mixerClose Lib "winmm.dll" (ByVal hmx As Long) As Long
Private Declare Function mixerGetControlDetails Lib "winmm.dll" Alias "mixerGetControlDetailsA" (ByVal hmxobj As Long, pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Long) As Long
Private Declare Function mixerGetDevCaps Lib "winmm.dll" Alias "mixerGetDevCapsA" (ByVal uMxId As Long, ByVal pmxcaps As MIXERCAPS, ByVal cbmxcaps As Long) As Long
Private Declare Function mixerGetID Lib "winmm.dll" (ByVal hmxobj As Long, pumxID As Long, ByVal fdwId As Long) As Long
Private Declare Function mixerGetLineControls Lib "winmm.dll" Alias "mixerGetLineControlsA" (ByVal hmxobj As Long, pmxlc As MIXERLINECONTROLS, ByVal fdwControls As Long) As Long
Private Declare Function mixerGetLineInfo Lib "winmm.dll" Alias "mixerGetLineInfoA" (ByVal hmxobj As Long, pmxl As MIXERLINE, ByVal fdwInfo As Long) As Long
Private Declare Function mixerGetNumDevs Lib "winmm.dll" () As Long
Private Declare Function mixerMessage Lib "winmm.dll" (ByVal hmx As Long, ByVal uMsg As Long, ByVal dwParam1 As Long, ByVal dwParam2 As Long) As Long
Private Declare Function mixerOpen Lib "winmm.dll" (phmx As Long, ByVal uMxId As Long, ByVal dwCallback As Long, ByVal dwInstance As Long, ByVal fdwOpen As Long) As Long
Private Declare Function mixerSetControlDetails Lib "winmm.dll" (ByVal hmxobj As Long, pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Long) As Long
Private Declare Sub CopyStructFromPtr Lib "kernel32" Alias "RtlMoveMemory" (struct As Any, ByVal ptr As Long, ByVal cb As Long)
Private Declare Sub CopyPtrFromStruct Lib "kernel32" Alias "RtlMoveMemory" (ByVal ptr As Long, struct As Any, ByVal cb As Long)
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalLock Lib "kernel32" (ByVal hmem As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hmem As Long) As Long

Private lMixerHnd As Long
Private tMIC As MIXERCONTROL
Private bHasMic As Boolean

Private Function GetMixer() As Boolean
    ' Get a Handle to the Mixer
    ' If we've already got one, return
    If lMixerHnd Then
        GetMixer = True
        Exit Function
    End If
    ' Get a new handle to the Mizer
    lReturn = mixerOpen(lMixerHnd, 0, 0, 0, 0)
    If lReturn = MMSYSERR_NOERROR Then
        GetMixer = True
    Else
        ' Problems opening the Mixer
        MsgBox "Unable to open mixer."
    End If
End Function

Public Function GetMicrophoneRecordVolume() As Long
    ' Retreives the current volume of the Microphone control (Recording)
    Dim lResult As Long, lMemHnd As Long
    Dim tMIXERCONTROLDETAILS As MIXERCONTROLDETAILS
    Dim tVOLUME As MIXERCONTROLDETAILS_UNSIGNED
   
    ' If we haven't gotten the Microphone Control yet, do so.
    If Not bHasMic Then bHasMic = GetMicControl()
    If Not bHasMic Then
        ' Unable to get the Microphone
        MsgBox "Unable to open Microphone Control"
        Exit Function
    End If
       
    ' Prep a MICERCONTROLDETAILS structure for retreiving info. about a specific control
    tMIXERCONTROLDETAILS.item = 0
    tMIXERCONTROLDETAILS.dwControlID = tMIC.dwControlID
    tMIXERCONTROLDETAILS.cbStruct = Len(tMIXERCONTROLDETAILS)
    tMIXERCONTROLDETAILS.cbDetails = Len(tVOLUME)
   
    ' Allocate a buffer for the control's value
    lMemHnd = GlobalAlloc(&H40, Len(tVOLUME))
    tMIXERCONTROLDETAILS.paDetails = GlobalLock(lMemHnd)
    tMIXERCONTROLDETAILS.cChannels = 1
   
    ' Get the controls details
    Call mixerGetControlDetails(lMixerHnd, tMIXERCONTROLDETAILS, MIXER_GETCONTROLDETAILSF_VALUE)
   
    ' Copy the data into the control's VOLUME struct
    CopyStructFromPtr tVOLUME, tMIXERCONTROLDETAILS.paDetails, Len(tVOLUME)
   
    ' Release the memory buffer
    Call GlobalFree(lMemHnd)
   
    ' Return the current value
    GetMicrophoneRecordVolume = tVOLUME.dwValue
End Function

Public Sub SetMicrophoneRecordVolume(ByVal lVolume As Long)
    ' Set the Microphone volume used for recording
    Dim lResult As Long, lMemHnd As Long
    Dim tMIXERCONTROLDETAILS As MIXERCONTROLDETAILS
    Dim tVOLUME As MIXERCONTROLDETAILS_UNSIGNED
   
    ' If we haven't got the Microphone yet, do so..
    If Not bHasMic Then bHasMic = GetMicControl()
    If Not bHasMic Then
        MsgBox "Unable to open Microphone Control"
        Exit Sub
    End If
       
    ' Prep the MIXERCONTROLDETAILS struct to set info. about this control
    tMIXERCONTROLDETAILS.item = 0
    tMIXERCONTROLDETAILS.dwControlID = tMIC.dwControlID
    tMIXERCONTROLDETAILS.cbStruct = Len(tMIXERCONTROLDETAILS)
    tMIXERCONTROLDETAILS.cbDetails = Len(tVOLUME)
   
    ' Allocate a buffer for the control's volume value
    lMemHnd = GlobalAlloc(&H40, Len(tVOLUME))
    tMIXERCONTROLDETAILS.paDetails = GlobalLock(lMemHnd)
    tMIXERCONTROLDETAILS.cChannels = 1
    tVOLUME.dwValue = lVolume
   
    ' Copy the data from the VOLUME struct into the memory buffer
    CopyPtrFromStruct tMIXERCONTROLDETAILS.paDetails, tVOLUME, Len(tVOLUME)
   
    ' Set the new volume
    Call mixerSetControlDetails(lMixerHnd, tMIXERCONTROLDETAILS, MIXER_SETCONTROLDETAILSF_VALUE)
   
    ' Release the memory buffer
    Call GlobalFree(lMemHnd)
End Sub

Private Function GetMicControl() As Boolean
    ' Get the Microphone Control (from the Recording Line)
    Dim tMIXERLINECONTROLS As MIXERLINECONTROLS
    Dim tMIXERLINE As MIXERLINE
    Dim lMemHnd As Long
    Dim lReturn As Long
    Dim lConnections As Long
    Dim lIndex As Long
   
    ' Get a handle to the Mixer
    If Not GetMixer() Then Exit Function
       
    ' First find the WAVEIN Line
    tMIXERLINE.cbStruct = Len(tMIXERLINE)
    tMIXERLINE.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_WAVEIN
   
    lReturn = mixerGetLineInfo(lMixerHnd, tMIXERLINE, MIXER_GETLINEINFOF_COMPONENTTYPE)
   
    If lReturn <> MMSYSERR_NOERROR Then Exit Function
   
    ' Next enumerate the connections for this line, checking for the Microphone
    lConnections = tMIXERLINE.cConnections - 1
   
    For lIndex = 0 To lConnections
        tMIXERLINE.dwSource = lIndex
        Call mixerGetLineInfo(lMixerHnd, tMIXERLINE, MIXER_GETLINEINFOF_SOURCE)
        If tMIXERLINE.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE Then
            Exit For
        End If
    Next
   
    ' If no microphone was found, exit
    If lIndex > lConnections Then Exit Function
   
    ' Extract the control for the Microphone from the line
    tMIXERLINECONTROLS.cbStruct = Len(tMIXERLINECONTROLS)
    tMIXERLINECONTROLS.dwLineID = tMIXERLINE.dwLineID
    tMIXERLINECONTROLS.dwControl = MIXERCONTROL_CONTROLTYPE_VOLUME
    tMIXERLINECONTROLS.cControls = 1
    tMIXERLINECONTROLS.cbmxctrl = Len(tMIC)
   
    ' Create a buffer for the Microphone
    lMemHnd = GlobalAlloc(&H40, Len(tMIC))
    tMIXERLINECONTROLS.pamxctrl = GlobalLock(lMemHnd)
    tMIC.cbStruct = Len(tMIC)
   
    ' Get the Microphone
    lReturn = mixerGetLineControls(lMixerHnd, tMIXERLINECONTROLS, MIXER_GETLINECONTROLSF_ONEBYTYPE)
         
    If (MMSYSERR_NOERROR = lReturn) Then
        GetMicControl = True
        ' Copy the Microphone control into the tMIC structure
        CopyStructFromPtr tMIC, tMIXERLINECONTROLS.pamxctrl, Len(tMIC)
    End If
   
    ' Release the buffer
    Call GlobalFree(lMemHnd)
End Function
